#!/bin/sh

SSDIR="$HOME/Library/Screen Savers"
GAMESSDIR="$SSDIR/Feeding Frenzy.saver"

if [ -d "$GAMESSDIR" ] ; then
    exit 0   # already done.
fi

echo "Installing Feeding Frenzy screensaver..."
mkdir -p "$SSDIR"
cp -Rv "Feeding Frenzy.saver" "$SSDIR/" || rm -rf "$GAMESSDIR"
cp -v FFArchive.saf "$GAMESSDIR/" || rm -rf "$GAMESSDIR"
cp -Rv resources "$GAMESSDIR/" || rm -rf "$GAMESSDIR"
cp -v Contents/MacOS/*.dylib "$GAMESSDIR/Contents/MacOS/" || rm -rf "$GAMESSDIR"
cp -v Contents/Resources/*.icns "$GAMESSDIR/Contents/Resources/" || rm -rf "$GAMESSDIR"

if [ -d "$GAMESSDIR" ] ; then
    echo "Screen saver is installed!"
fi

exit 0

